<?php
/**
 * User: timothy
 * Date: 2018/07/01
 * Time: 8:52 AM
 * notes : 0 == null, causes JSON Render Bug of dropped key and value
 *    change 0 to '0' to fix
 */

class User extends Controller
{
	private $cols;
	private $col;
	private $tables;
	public $db;
	public function __construct()
	{
		$this->tables= ["dogmative_network.user"];
		$this->cols = [["username","concat(`name`,concat(' ',surname)) as fullname",
			"`name`","`surname`","email","phone","phone","dob","country",
			'profilepic','id'],["username","password","name","surname","email","dob","profilepic","status"]];
		$this->db = new Q_ueryBuild();
	}

	public  function get_user($id){
		$db = $this->db;
		$table = $this->tables[0];
		$qry = Q_ueryBuild::slct("*",$table,"id='$id'" .
			" or username like '$id' or email like '$id'");
		$stmt = $db->transaction($qry);
		$stmt->execute();
		return $stmt->fetchAll(PDO::FETCH_ASSOC);
	}

	public function get_list($data){
		$db = $this->db;
		$table = $this->tables[0];
		$limit=$this->limiter($data,1);
		$this->silenced = ["password","email","limit","offset"];
		$col = $this->silence([],$this->col);
		$qry = Q_ueryBuild::slct($col,$table,$limit);
		$stmt = $db->transaction($qry);
		$stmt->execute();
		return $stmt->fetchAll(PDO::FETCH_ASSOC);
	}
	/**
	 * @param $obj
	 * @throws Exception
	 * @return array
	 */
	public function add($obj)
	{
		$db = $this->db;
		$obj = $this->hash($obj);
		$col = $this->setCols_o($this->cols[1],$obj);
		$vls = Controller::valuate_o([],$col,$obj);
		$user_reg = $this->get_user($obj['username']);
		if (sizeof($user_reg)>0) throw new Exception("User Exists");
		$qry = Q_ueryBuild::insert($this->tables[0],$col,$vls);
		$stmt = $db->transaction($qry);
		$stmt->execute();
		return ["id"=>$db->db->lastInsertId()];
	}
	/**
	 * @param $obj
	 * @throws Exception
	 * @return array
	 */
	public function login($obj){
		$obj = $this->hash($obj);
		$what = "(username='{$obj["username"]}' or email='{$obj["email"]}') " .
			"and password='{$obj["password"]}'";
		$qry = Q_ueryBuild::slct($this->cols[0],$this->tables[0],$what);
		//throw new ErrorException($qry);
		$stmt = $this->db->transaction($qry);
		$stmt->execute();
		$res = $stmt->fetchAll(PDO::FETCH_ASSOC);
//		$res = [$what];
		return $res;
	}
	private function update($obj){
		$obj = $this->hash($obj);
		$col = self::setCols_o($this->cols[1],$obj);
		$what = Controller::valuesToString_o($col,$obj);
		$qry = Q_ueryBuild::update($this->tables[0],$what,"id='{$obj["id"]}'");
		//throw new ErrorException($qry);
		$res = $this->db->transaction($qry)->execute();
		return ["id"=>$obj["id"],"query"=>$res,"s"=>$obj];
	}

	protected function limiter($data,$set){
		$limit = null;
		if ($data) {
			$this->col = Controller::setCols_o($this->cols[$set],$data);
			return "1=1 limit " . ($data->limit == null ? 10 : $data->limit == null) .
			" offset " . $data->offset == null ? 0 : $data->offset;

		} else {
			$this->col = Controller::setCols($this->cols[$set]);
			return  "1=1 limit " . Controller::input("limit",10,INPUT_POST) .
				" offset " . Controller::input("offset",0,INPUT_POST);

		}
	}
	public function randomizer(){
		$arr = [];
		for ($a = 0;$a < 6;$a++){
			array_push($arr,rand(1,9));
		}
		return join("",$arr);
	}
	public function reset_password_request($email){
		$users = $this->get_user($email);
		$user=(sizeof($users)>0)? $users[0]:null;
		if ($user!=null) {
			$user["password"] = null;
			$user["status"] = $this->randomizer();
			$this->update($user);
			$msg = "Hi {$user['username']},<br>" . PHP_EOL;
			$msg .= "<p> Please Use the following pin to reset password <br>" . PHP_EOL;
			$msg .= " <b>Pin: {$user["status"]}</b><br></p>" . PHP_EOL;
			$msg .= "Regards<br> Dogmative Network" . PHP_EOL;
			$user['m'] = Controller::mailer($email, "Reset Password Pin", $msg,'support');
			$user["status"] = "Password Reset Ready";
			return json_encode($user);
		}else{
			return'{"msg":"mailer failed","user":"'.json_encode($user).'","why":"User Not Found!"}';
		}
	}
	public function reset_password_accept($user){
		$users = $this->get_user($user["email"]);
		$user_d=(sizeof($users)>0)? $users[0]:null;
		if ($user!=null && $user["status"]==$user_d["status"] && $user_d['status']!=0) {
			$user  = $this->hash($user);
			$user_d["status"] = '0';
			$user_d["password"] = $user["password"];
			$res = $this->update($user_d);
			$msg = "Hi {$user['username']},<br>" . PHP_EOL;
			$msg .= "<p> PassWord Has Been Reset <br>" . PHP_EOL;
			$msg .= " <b></b><br/></p>" . PHP_EOL;
			$msg .= "Regards<br/> Dogmative Network" . PHP_EOL;
			$user['m'] = Controller::mailer($user["email"], "Reset Password Pin", $msg,'support');
			return json_encode(["msg"=>"ok","why"=>"Password Reset","m"=>$user['m'],"ex"=>$res]);
		}else{
			return'{"msg":"reset failed","user":'.json_encode($user).',"why":"Password Reset Session Invalid !"}';
		}
	}
	public function update_expose($obj){
		$obj['password'] = 0;//Disable Password reset
		return $this->update($obj);
	}
}